<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\Http\Controllers\Controller;
use App\Libraries\Parser;
use App\Libraries\Utils;
use App\Posts;
use App\Sources;
use App\SubCategories;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Input;
use Session;

class SourcesController extends Controller
{

    public function create()
    {
        return view('admin.sources.create', ['categories' => Categories::all()]);
    }

    public function store()
    {

        if (!Input::has('url')) {
            Session::flash('error_msg', 'Feed URL is required');
            return redirect()->back()->withInput(Input::all());
        }

        if (!Input::has('sub_category')) {
            Session::flash('error_msg', 'Sub Category is required');
            return redirect()->back()->withInput(Input::all());
        }

        if (!filter_var(Input::get('url'), FILTER_VALIDATE_URL)) {
            Session::flash('error_msg', 'Invalid URL , URL should start with https:// or http://');
            return redirect()->back()->withInput(Input::all());
        }

        if (sizeof(Sources::where('url', Input::get('url'))->get()) > 0) {
            Session::flash('error_msg', 'Source with given url already exists');
            return redirect()->back()->withInput(Input::all());
        }

        $url = Input::get('url');

        $feed = Parser::xml($url);

        $source = new Sources();
        $source->url = Input::get('url');
        $source->priority = Input::get('priority');
        $source->category_id = Input::get('sub_category');
        $source->channel_title = isset($feed['channel']['title']) ? $feed['channel']['title'] : '';
        $source->channel_link = isset($feed['channel']['link']) ? $feed['channel']['link'] : '';
        $source->channel_description = isset($feed['channel']['description']) ? $feed['channel']['description'] : '';
        $source->channel_language = isset($feed['channel']['language']) ? $feed['channel']['language'] : '';
        $source->channel_pubDate = isset($feed['channel']['pubDate']) ? $feed['channel']['pubDate'] : '';
        $source->channel_lastBuildDate = isset($feed['channel']['lastBuildDate']) ? $feed['channel']['lastBuildDate'] : '';
        $source->channel_generator = isset($feed['channel']['generator']) ? $feed['channel']['generator'] : '';
        $source->auto_update = Input::has('auto_update') ? 1 : 0;
        $source->items_count = isset($feed['channel']['item']) ? sizeof($feed['channel']['item']) : 0;
        $source->save();

        if (isset($feed['channel']['item'])) {
            foreach ($feed['channel']['item'] as $item) {
                if (!is_null($item['title']) && !is_null($item['description']) && !is_null($item['pubDate']) && !is_null($item['link'])) {

                    //If same title not present then only insert
                    if (sizeof(Posts::where('title', Input::get('title'))->get()) <= 0) {

                        $find_img = Utils::getImageWithSizeGreaterThan($item['description']);

                        $post_item = new Posts();
                        $post_item->author_id = \Auth::user()->id;
                        $post_item->title = isset($item['title']) ? $item['title'] : '';
                        $post_item->slug = isset($item['title']) ? Str::slug($item['title']) : '';
                        $post_item->link = isset($item['link']) ? $item['link'] : '';
                        $post_item->featured = 0;
                        $post_item->category_id = Input::get('sub_category');
                        $post_item->render_type = strlen($find_img) > 0 ? Posts::RENDER_TYPE_IMAGE : Posts::RENDER_TYPE_TEXT;
                        $post_item->type = Posts::TYPE_SOURCE;
                        $post_item->source_id = $source->id;
                        $post_item->rating_box = 0;
                        $post_item->description = isset($item['description']) ? $item['description'] : '';
                        $post_item->featured_image = $find_img;
                        $post_item->created_at = isset($item['pubDate']) ? Carbon::createFromFormat("D, j F Y H:i:s O", $item['pubDate'])->format('Y-m-d H:i:s') : '';
                        $post_item->views = 1;
                        $post_item->save();
                    }
                }
            }
        }

        Session::flash('success_msg', 'Source created successfully');
        return redirect()->to('/admin/sources/all');

    }


    public function edit($id)
    {

        if (!is_null($id) && sizeof(Sources::where('id', $id)->get()) > 0) {

            $source = Sources::where('id', $id)->first();

            $source->category = SubCategories::where('id', $source->category_id)->first();
            $source->parent_category = Categories::where('id', $source->category->parent_id)->first();

            return view('admin.sources.edit', ['source' => $source, 'categories' => Categories::all()]);

        } else {
            Session::flash('error_msg', 'Source not found');
            return redirect()->to('/admin/sources/all');
        }

    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(Sources::where('id', $id)->get()) > 0) {

            Posts::where('source_id', $id)->delete();
            Sources::where('id', $id)->delete();

            Session::flash('success_msg', 'Source deleted successfully');
            return redirect()->to('/admin/sources/all');

        } else {
            Session::flash('error_msg', 'Source not found');
            return redirect()->to('/admin/sources/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(Sources::where('id', Input::get('id'))->get()) > 0) {

            if (!Input::has('sub_category')) {
                Session::flash('error_msg', 'Sub Category is required');
                return redirect()->back()->withInput(Input::all());
            }

            if (sizeof(Sources::where('url', Input::get('url'))->where('id', '!=', Input::get('id'))->get()) > 0) {
                Session::flash('error_msg', 'Source already exists');
                return redirect()->back()->withInput(Input::all());
            }

            if (!filter_var(Input::get('url'), FILTER_VALIDATE_URL)) {
                Session::flash('error_msg', 'Invalid URL , Feed URL should start with https:// or http://');
                return redirect()->back()->withInput(Input::all());
            }


            $url = Input::get('url');

            $feed = Parser::xml($url);

            Posts::where('source_id', Input::get('id'))->delete();

            $source = Sources::where('id', Input::get('id'))->first();

            $source->url = Input::get('url');
            $source->priority = Input::get('priority');
            $source->category_id = Input::get('sub_category');
            $source->channel_title = isset($feed['channel']['title']) ? $feed['channel']['title'] : '';
            $source->channel_link = isset($feed['channel']['link']) ? $feed['channel']['link'] : '';
            $source->channel_description = isset($feed['channel']['description']) ? $feed['channel']['description'] : '';
            $source->channel_language = isset($feed['channel']['language']) ? $feed['channel']['language'] : '';
            $source->channel_pubDate = isset($feed['channel']['pubDate']) ? $feed['channel']['pubDate'] : '';
            $source->channel_lastBuildDate = isset($feed['channel']['lastBuildDate']) ? $feed['channel']['lastBuildDate'] : '';
            $source->channel_generator = isset($feed['channel']['generator']) ? $feed['channel']['generator'] : '';
            $source->auto_update = Input::has('auto_update') ? 1 : 0;
            $source->items_count = isset($feed['channel']['item']) ? sizeof($feed['channel']['item']) : 0;
            $source->save();

            if (isset($feed['channel']['item'])) {
                foreach ($feed['channel']['item'] as $item) {
                    if (!is_null($item['title']) && !is_null($item['description']) && !is_null($item['pubDate']) && !is_null($item['link'])) {
                        $exists_post = Posts::where('slug', Str::slug($item['title']))->first();

                        if (empty($exists_post)) {

                            $find_img = Utils::getImageWithSizeGreaterThan($item['description']);

                            $post_item = new Posts();
                            $post_item->author_id = \Auth::user()->id;
                            $post_item->title = isset($item['title']) ? $item['title'] : '';
                            $post_item->slug = isset($item['title']) ? Str::slug($item['title']) : '';
                            $post_item->link = isset($item['link']) ? $item['link'] : '';
                            $post_item->featured = 0;
                            $post_item->category_id = Input::get('sub_category');
                            $post_item->type = Posts::TYPE_SOURCE;
                            $post_item->render_type = strlen($find_img) > 0 ? Posts::RENDER_TYPE_IMAGE : Posts::RENDER_TYPE_TEXT;
                            $post_item->source_id = $source->id;
                            $post_item->description = isset($item['description']) ? $item['description'] : '';
                            $post_item->featured_image = $find_img;
                            $post_item->views = 1;
                            $post_item->save();
                        } else {
                            $exists_post->link = isset($item['link']) ? $item['link'] : '';
                            $exists_post->description = isset($item['description']) ? $item['description'] : '';
                            $exists_post->save();
                        }
                    }
                }
            }

            $source->save();

            Session::flash('success_msg', 'Source updated successfully');
            return redirect()->to('/admin/sources/all');

        } else {
            Session::flash('error_msg', 'Source not found');
            return redirect()->to('/admin/sources/all');
        }

    }

    public function pullFeeds()
    {

        if (!Input::has('url')) {
            return response()->json(['result' => 0, 'message' => 'Feed URL is required']);
        }

        if (!filter_var(Input::get('url'), FILTER_VALIDATE_URL)) {
            return response()->json(['result' => 0, 'message' => 'Invalid URL , URL should start with https:// or http://']);
        }

        $url = Input::get('url');

        $feed = Parser::xml($url);

        $data = [];

        if (sizeof(isset($feed['channel']['item']) > 0)) {

            $first_feed = $feed['channel']['item'][rand(0, sizeof($feed['channel']['item']) - 1)];

            $data['title'] = isset($first_feed['title']) ? $first_feed['title'] : '';
            $data['description'] = isset($first_feed['description']) ? $first_feed['description'] : '';

        }

        return response()->json(['result' => 1, 'data' => $data]);

    }

    public function all()
    {

        $sources = Sources::all();

        foreach ($sources as $source) {
            $source->category = SubCategories::where('id', $source->category_id)->first();
        }

        return view('admin.sources.all', ['sources' => $sources]);
    }

}